/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.mother_silverfish.setup;

import com.hollingsworth.mother_silverfish.entity.BabyFish;
import com.hollingsworth.mother_silverfish.entity.BabyPoisonFish;
import com.hollingsworth.mother_silverfish.entity.HealthStealFish;
import com.hollingsworth.mother_silverfish.entity.ItemStealFish;
import com.hollingsworth.mother_silverfish.entity.MotherSilverfishEntity;
import com.hollingsworth.mother_silverfish.entity.SpecialFallingBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="mother_silverfish")
public class EntityRegistry {
    public static EntityType<MotherSilverfishEntity> ENTITY_MOTHER_SILVER = null;
    public static EntityType<BabyPoisonFish> POISON_FISH = null;
    public static EntityType<HealthStealFish> HEALTH_STEAL_FISH = null;
    public static EntityType<ItemStealFish> ITEM_STEAL_FISH = null;
    public static EntityType<SpecialFallingBlock> FALLING_BLOCK = null;

    @Mod.EventBusSubscriber(modid="mother_silverfish", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            ENTITY_MOTHER_SILVER = RegistrationHandler.build("mother_silverfish", EntityType.Builder.m_20704_(MotherSilverfishEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.0f, 1.7f).setTrackingRange(10));
            POISON_FISH = RegistrationHandler.build("poison_silverfish", EntityType.Builder.m_20704_(BabyPoisonFish::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.5f).setTrackingRange(10));
            HEALTH_STEAL_FISH = RegistrationHandler.build("leech_silverfish", EntityType.Builder.m_20704_(HealthStealFish::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.5f).setTrackingRange(10));
            ITEM_STEAL_FISH = RegistrationHandler.build("thief_silverfish", EntityType.Builder.m_20704_(ItemStealFish::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.5f).setTrackingRange(10));
            FALLING_BLOCK = RegistrationHandler.build("special_falling_block", EntityType.Builder.m_20704_(SpecialFallingBlock::new, (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.98f).setShouldReceiveVelocityUpdates(true).setTrackingRange(256));
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{ENTITY_MOTHER_SILVER, POISON_FISH, HEALTH_STEAL_FISH, ITEM_STEAL_FISH, FALLING_BLOCK});
        }

        @SubscribeEvent
        public static void registerEntities(EntityAttributeCreationEvent event) {
            event.put(ENTITY_MOTHER_SILVER, MotherSilverfishEntity.attributes().m_22265_());
            event.put(POISON_FISH, BabyFish.attributes().m_22265_());
            event.put(HEALTH_STEAL_FISH, BabyFish.attributes().m_22265_());
            event.put(ITEM_STEAL_FISH, BabyFish.attributes().m_22265_());
        }

        private static <T extends Entity> EntityType<T> build(String name, EntityType.Builder<T> builder) {
            ResourceLocation registryName = new ResourceLocation("mother_silverfish", name);
            EntityType entityType = builder.m_20712_(registryName.toString());
            entityType.setRegistryName(registryName);
            return entityType;
        }
    }
}

